# encoding: UTF-8
'''
    Copyright (c) 2020-8 Arducam <http://www.arducam.com>.

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
    DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
    OR OTHER DEALINGS IN THE SOFTWARE.
'''

#Bibliothèque pour gérer les servoKit (DOIT ETRE APPELER SUR CHAQUE SCRIPT UTILISANT LES SERVOKIT)


import os
import sys

import adafruit_servokit
import curses
import Jetson.GPIO as GPIO

from ultralytics import YOLO
import math
import time




class ServoKit(object):


    def __init__(self, choixTK, setRotation = 45, MiddleAngleServoBottom = 90, MiddleAngleServoTop = 90, NumCamera = 0):
        print("Initializing the servo...")
        self.kit = adafruit_servokit.ServoKit(channels=16)
     
        self.setRotation = setRotation
        self.MiddleAngleServoBottom = MiddleAngleServoBottom
        self.MiddleAngleServoTop = MiddleAngleServoTop
        self.NumCamera = NumCamera

        # renseignement du tracking kit
        #choixTK = input("Renseignez le numéro du tracking kit (1, 2 ou 3) : ")
        if (choixTK == 1):
            print("Vous avez choisi le tracking kit 1")
            self.calibTrackingKit(1)

        elif (choixTK == 2):
            print("Vous avez choisi le tracking kit 2")
            self.calibTrackingKit(2)
        elif (choixTK == 3):
            print("Vous avez choisi le tracking kit 3")
            self.calibTrackingKit(3)
        else:
            print("Choix invalide")

        #self.NumCamera = int(input("Renseignez le numéro (0,2, 4, 6 ...) assigné à la camera (Pour trouver le numéro, insérez dans un terminal : 'v4l2-ctl --list-devices') : "))

        self.resetAll()
        print("Initializing complete.")


    def calibTrackingKit(self, numéroKit):
        print("Tracking Kit Calibration")
        if(numéroKit == 1): #Valeur de calibration selon le servokit (1 = servoKit1, 2 = servoKit 2 etc...)
            self.MiddleAngleServoBottom = 50
            self.MiddleAngleServoTop = 70
            self.setMaxRotation(30)
        if (numéroKit == 2):
            self.MiddleAngleServoBottom = 40
            self.MiddleAngleServoTop = 160
            self.setMaxRotation(30)
        if (numéroKit == 3):
            self.MiddleAngleServoBottom = 130
            self.MiddleAngleServoTop = 160
            self.setMaxRotation(30)


    def setMaxRotation(self, angleMax):

        if angleMax > 90:
            angleMax = 90
        elif angleMax < -90:
            angleMax = -90
        self.setRotation = angleMax

    def getMaxRotation(self):
        return self.setRotation

    def setAngle(self, port, angle):
        if angle < 0:
            self.kit.servo[port].angle = 0
        elif angle > 180:
            self.kit.servo[port].angle = 180
        else:
            self.kit.servo[port].angle = angle

    def getNumCamera(self):
        return self.NumCamera

    def setAngleDeg(self, port, angle):

        if angle < -self.setRotation:
            angle = -self.setRotation
        elif angle > self.setRotation:
            angle = self.setRotation

        angle = angle / 135 * 180 #Conversion approximatif fait à l'oeil

        if(port == 0):
            angle = angle + self.MiddleAngleServoBottom
        elif (port == 1):
            angle = angle + self.MiddleAngleServoTop

        if angle < 0:
            self.kit.servo[port].angle = 0
        elif angle > 180:
            self.kit.servo[port].angle = 180
        else:
            self.kit.servo[port].angle = angle




    def getAngle(self, port):
        return self.kit.servo[port].angle

    def getAngleDeg(self, port):

        angle = self.kit.servo[port].angle

        if(port == 0):
            angle = angle - self.MiddleAngleServoBottom
        if (port == 1):
            angle = angle - self.MiddleAngleServoTop

        angle = (angle /180) * 135

        return angle

    def reset(self, port):
        self.kit.servo[port].angle = self.MiddleAngleServoBottom

    def resetAll(self):

        self.kit.servo[0].angle = self.MiddleAngleServoBottom
        self.kit.servo[1].angle = self.MiddleAngleServoTop




    def testCalib(self):
        for i in range(self.MiddleAngleServoBottom, 180, 5):
            self.setAngle(0, i)
            self.setAngle(3, i)
            time.sleep(.05)

        for i in range(0, 180, 5):
            self.setAngle(0, 180 - i)
            self.setAngle(3, 180 - i)
            time.sleep(.05)

        for i in range(0, self.MiddleAngleServoBottom, 5):
            self.setAngle(0, i)
            self.setAngle(3, i)
            time.sleep(.05)


        for i in range(self.MiddleAngleServoTop, 180, 5):
            self.setAngle(1, i)
            self.setAngle(3, i)
            time.sleep(.05)
            time.sleep(.05)

        for i in range(0, 180, 5):
            self.setAngle(1, 180 - i)
            self.setAngle(3, 180 - i)
            time.sleep(.05)

        for i in range(0, self.MiddleAngleServoTop, 5):
            self.setAngle(1, i)
            self.setAngle(3, i)
            time.sleep(.05)









