import cv2
import math
import numpy as np
import subprocess
import time
import requests
import tkinter as tk
from tkinter import Label
from PIL import Image, ImageTk
from ultralytics import YOLO
import tkinter as tk
from tkinter import ttk, filedialog, messagebox



def refind_2d_coord(posX, posY, posZ, focalX, focalY, width, height):
    if (posZ != 0):
        thetaX = math.atan(posX / posZ)
        thetaY = math.atan(posY / posZ)
        x = thetaX * focalX + (width / 2)
        y = thetaY * focalY + (height / 2)
        return int(x), int(y)
    return 0, 0


def vueDuDessus(polygon_points, posXP1, posZP1, focalXPixel, width, height, coordFactor, zoneXmin, zoneXmax, zoneZmin,
                zoneZmax, hauteurCam):
    center = (width // 2, height // 4)

    image = np.ones((width, height, 3), dtype=np.uint8) * 255  # Fond blanc
    # Redimensionnement pour OpenCV (attendu en (n, 1, 2))
    polygon_points = polygon_points.reshape((-1, 1, 2))
    # Remplir le polygone (facultatif)
    cv2.fillPoly(image, [polygon_points], color=(200, 0, 0))
    cv2.putText(image, f"Zone : X = {round(zoneXmin, 3)}, {round(zoneXmax, 3)}", (20, 40), cv2.FONT_HERSHEY_SIMPLEX,
                1, (0, 0, 0), 2, cv2.LINE_AA)
    cv2.putText(image, f"Zone : Z = {round(zoneZmin, 3)}, {round(zoneZmax, 3)}", (20, 80), cv2.FONT_HERSHEY_SIMPLEX,
                1, (0, 0, 0), 2, cv2.LINE_AA)

    cv2.putText(image, f"Hauteur Cam= {round(hauteurCam, 1)}", (20, 120), cv2.FONT_HERSHEY_SIMPLEX,
                1, (0, 0, 0), 2, cv2.LINE_AA)

    cv2.circle(image, (int(posXP1 * coordFactor + center[0]), int(posZP1 * coordFactor + center[1])), radius=5,
               color=(0, 0, 255), thickness=-1)
    cv2.line(image, (center[0] - 100, center[1]), (center[0] + 100, center[1]), (0, 255, 0), 1)
    cv2.line(image, (center[0], center[1] - 100), (center[0], center[1] + 100), (0, 0, 255), 1)

    return image


def find_depth(left_point, right_point, frameLeft, frameRight, left_angleX, right_angleX, baseline, fovLeft, fovRight):
    leftHeight, leftWidth, leftDepth = frameLeft.shape
    rightHeight, rightWidth, rightDepth = frameRight.shape

    fPixelLeft = 0
    fPixelRight = 0
    if leftWidth == rightWidth:
        fPixelLeft = (leftWidth * 0.5) / math.tan(fovLeft * 0.5 * math.pi / 180)
        fPixelRight = (rightWidth * 0.5) / math.tan(fovRight * 0.5 * math.pi / 180)
    else:
        print("Les camÃ©ras n'ont pas la mÃªme taille")

    xcamLeft = left_point[0]
    xcamRight = right_point[0]

    disparity = (xcamLeft - xcamRight)
    zDepth = 0

    if (disparity != 0):
        zDepthLeft = abs((baseline * fPixelLeft) / disparity)
        zDepthRight = abs((baseline * fPixelRight) / disparity)
        zDepth = (zDepthLeft + zDepthRight) / 2

    return disparity, zDepth


def coordCalculator(left_point, right_point, frameLeft, frameRight, left_angleX, right_angleX, left_angleY,
                    right_angleY, baseline, fovLeft, fovRight):
    leftHeight, leftWidth, leftDepth = frameLeft.shape
    rightHeight, rightWidth, rightDepth = frameRight.shape

    xcamLeft = left_point[0]
    xcamRight = right_point[0]

    ycamLeft = left_point[1]
    ycamRight = right_point[1]

    disparity, posZ = find_depth(left_point, right_point, frameLeft, frameRight, left_angleX, right_angleX, baseline,
                                 fovLeft, fovRight)

    thetaX = right_angleX  # moyenne des angles
    thetaY = right_angleY  # moyenne des angles
    posX = posZ * math.tan(math.radians(thetaX))
    posY = posZ * math.tan(math.radians(thetaY))

    return disparity, posX, posY, posZ


def danger_zone_show(frame, app_state):
    # ParamÃ¨tres
    rectColor = (0, 0, 0)
    cam_width, cam_height = 1920, 1080
    ResizeWidth = 1920  # Resize des caméra stereoscopique pour affichage. Les deux caméras sont resize de manière identique
    ResizeHeight = 1080
    frame_rate = 30
    cam_distance = 0.25
    zone_xmin, zone_xmax = -0.5, 0.5
    zone_zmin, zone_zmax = 0.0, 1.5
    cam_fov_h = 94.4
    cam_fov_v = 59.3
    fx_pixel = (ResizeWidth * 0.5) / math.tan(math.radians(cam_fov_h / 2))
    fy_pixel = (ResizeHeight * 0.5) / math.tan(math.radians(cam_fov_v / 2))
    InterfaceCoordFactor = 100

    # Variables pour le tracking
    CenterCam1P1 = None
    CenterCam2P1 = None
    angleXcam1P1 = 0
    angleXcam2P1 = 0
    angleYcam1P1 = 0
    angleYcam2P1 = 0
    posXP1 = 0
    posYP1 = 0
    posZP1 = 0

    # ParamÃ¨tres de l'interface
    interface_width = 1000
    interface_height = 1000
    interface_coord_factor = 100
    hauteurCam = 1.0  # Valeur par dÃ©faut

    camObjectAngleX = 0
    camObjectAngleY = 0

    xSaveCam1 = []
    xSaveCam2 = []

    InZone = True

    threshold = 75

    # Variable pour le calcul de FPS
    last_time = time.time()
    initTime = time.time()
    frameCount = 0
    last_timeCalcul = time.time()
    elapsedTime = 0



    # VÃ©rifier les camÃ©ras fixes
    fix_cameras = list(app_state["fix_cameras"].items())
    print(fix_cameras)
    if len(fix_cameras) < 2:
        messagebox.showerror("Erreur", "Il faut au moins deux camÃ©ras fixes pour cette fonctionnalité")
        return

    # Récupérer les deux premiÃ¨res camÃ©ras fixes
    camera1 = fix_cameras[0][1][1]
    camera2 = fix_cameras[1][1][1]
    
    if not camera1.isOpened() or not camera2.isOpened():
        messagebox.showerror("Erreur", "Impossible d'ouvrir les caméras")
        return

    # Initialiser le modÃ¨le YOLO
    model = ##########

    # Variables d'Ã©tat
    state = {
        "tracking": True,
        "video_running": True,
        "danger_sent": False
    }
    # Calcul taille écran
    root = tk.Tk()
    screen_width = root.winfo_screenwidth()
    screen_height = root.winfo_screenheight()
    root.destroy()

    # Créer les frames pour l'interface
    main_frame = ttk.Frame(frame)
    main_frame.pack(pady=10, fill=tk.BOTH, expand=True)

    # Diviser main_frame en 2 lignes :
    # Ligne 0 = caméras en haut
    # Ligne 1 = interface et sliders en bas
    main_frame.columnconfigure(0, weight=1)
    main_frame.columnconfigure(1, weight=1)
    main_frame.rowconfigure(0, weight=1)
    main_frame.rowconfigure(1, weight=1)

    # Frame pour les caméras (ligne 0, colonne 0-1)
    cameras_frame = ttk.Frame(main_frame)
    cameras_frame.grid(row=0, column=0, columnspan=2, sticky="nsew")

    # Frame interface bas gauche
    top_view_frame = ttk.Frame(main_frame)
    top_view_frame.grid(row=1, column=0, sticky="nsew")

    # Frame sliders bas droite
    controls_frame = ttk.Frame(main_frame)
    controls_frame.grid(row=1, column=1, sticky="nsew")

    # Labels pour les camÃ©ras avec une taille fixe
    video_labels = []
    for i in range(2):
        label = ttk.Label(cameras_frame)
        label.grid(row=0, column=i, padx=5, pady=5)
        video_labels.append((label, f"Caméra {i + 1}"))

    # Label pour l'interface de vue du dessus
    interface_label = ttk.Label(top_view_frame)
    interface_label.pack(fill=tk.BOTH, expand=True, padx=5, pady=5)

    # Variables pour les sliders
    hauteur_var = tk.DoubleVar(value=1.0)
    taille_zone_x_var = tk.DoubleVar(value=2.0)
    taille_zone_z_var = tk.DoubleVar(value=2.0)
    horizontal_move_var = tk.DoubleVar(value=5.0)
    depth_move_var = tk.DoubleVar(value=7.0)

    # CrÃ©ation des sliders avec des plages de valeurs adaptÃ©es
    ttk.Label(controls_frame, text="Hauteur Caméra:").pack()
    ttk.Scale(controls_frame, from_=0.1, to=2.0, variable=hauteur_var, orient=tk.HORIZONTAL).pack(fill=tk.X)

    ttk.Label(controls_frame, text="Taille Zone X:").pack()
    ttk.Scale(controls_frame, from_=0.1, to=10.0, variable=taille_zone_x_var, orient=tk.HORIZONTAL).pack(fill=tk.X)

    ttk.Label(controls_frame, text="Taille Zone Z:").pack()
    ttk.Scale(controls_frame, from_=0.1, to=10.0, variable=taille_zone_z_var, orient=tk.HORIZONTAL).pack(fill=tk.X)

    ttk.Label(controls_frame, text="DÃ©placement Horizontal:").pack()
    ttk.Scale(controls_frame, from_=0.0, to=10.0, variable=horizontal_move_var, orient=tk.HORIZONTAL).pack(fill=tk.X)

    ttk.Label(controls_frame, text="DÃ©placement Profondeur:").pack()
    ttk.Scale(controls_frame, from_=0.0, to=10.0, variable=depth_move_var, orient=tk.HORIZONTAL).pack(fill=tk.X)

    # Bouton Retour en dessous des sliders
    ttk.Button(controls_frame, text="Retour", command=lambda: frame.destroy()).pack(pady=10)

    def update_frame():
        if not state["video_running"]:
            return

        ret1, frame1 = camera1.read()
        ret2, frame2 = camera2.read()

        if not ret1 or not ret2:
            video_labels[0][0].after(30, update_frame)
            return

        frame1 = cv2.flip(frame1, 0)
        frame2 = cv2.flip(frame2, 0)

        if state["tracking"]:
            # DÃ©tection avec YOLO
            results = model([frame1, frame2], stream=True, batch=2, verbose=False)
            allCamPosPerson = []

            for i, r in enumerate(
                    results):  # On vient récupérer l'ensemble des résultats (result est une liste contenant l'ensemble des coordonnées des points)

                keypoints = r.keypoints.xy  # On récupère une liste de tous les keypoints detecté

                for j in range(len(keypoints)):  # On navigue dans cette liste

                    if (len(keypoints[0]) > 0):  # Si la liste n'est pas vide, on récupère les valeurs en x et en y

                        keypointsFound = False
                        x, y = int(keypoints[j][0][0]), int(keypoints[j][0][1])

                        for k in range(len(keypoints[
                                               j])):  # On navigue sur tous les points du corps (17 points) (Pour robustesse ( Facultatif))

                            # cv2.circle(frame[i], (int(keypoints[0][k][0]), int(keypoints[0][k][1])),radius=5,color=(0, 255, 255), thickness=-1)

                            if (keypointsFound == False and (keypoints[j][k][0] != 0 and keypoints[j][k][0] != 0)):

                                x, y = int(keypoints[j][k][0]), int(keypoints[j][k][1])
                                keypointsFound = True
                                # print("valeur du keypoint trouvé : ", k)

                                if (
                                        k % 2 == 1):  # On vérifie si k est impair car toutes les pairs (epaule, coude, oreille) commence par un nombre impair. (k = 3 = oreille gauche, k = 5 = épaule gauche, k = 7 = coude gauche etc...) Si il est a l'épaule gauche, vérifié si il trouve l'épaule droite et prendre la moyenne des positions des deux pour pouvoir prendre le milieu des 2 épaules. Pareil pour coude et pour hanche et pour genou et pour cheville

                                    if (keypoints[j][k + 1][0] != 0 and keypoints[j][k + 1][1] != 0):
                                        x, y = int(keypoints[j][k][0] + (
                                                    (keypoints[j][k + 1][0] - keypoints[j][k][0]) / 2)), int(
                                            keypoints[j][k][1] + ((keypoints[j][k + 1][1] - keypoints[j][k][
                                                1]) / 2))  # On prend le milieu

                                elif (
                                        k % 2 == 0 and k != 0):  # on skip car il a pas trouvé l'autre pair pour faire la moyenne sauf pour le nez
                                    keypointsFound = False

                                if (keypointsFound):
                                    break

                        if i == 0:  # On repère à quelle caméra appartiennent les coordonnées pris dans la boucle

                            focalPixel = (ResizeWidth * 0.5) / math.tan(
                                cam_fov_h * 0.5 * math.pi / 180)  # Cacul de la focal en pixel en fonction de la valeur de resize défini (par défaut, les caméra sont en 1920x1080).
                            focalYpixel = (ResizeHeight * 0.5) / math.tan(
                                cam_fov_v * 0.5 * math.pi / 180)  # Cacul de la focal en pixel en fonction de la valeur de resize défini (par défaut, les caméra sont en 1920x1080).

                            camObjectAngleX = math.degrees(
                                math.atan((x - (
                                            ResizeWidth / 2)) / focalPixel))  # Calcul de l'angle X du point par rapport à la caméra. Approche avec perspective

                            camObjectAngleY = - math.degrees(math.atan((y - (
                                    ResizeHeight / 2)) / focalYpixel))  # Calcul de l'angle Y du point par rapport à la caméra. Approche avec perspective (Vu que le repère de opencv est en haut a gauche, si on met pas la valeur négatif de l'angle, nous auront nos coord cartésien en Y inversé)

                        if i == 1:  # On fait la même chose pour l'autre caméra

                            focalPixel = (ResizeWidth * 0.5) / math.tan(cam_fov_h * 0.5 * math.pi / 180)
                            focalYpixel = (ResizeHeight * 0.5) / math.tan(cam_fov_v * 0.5 * math.pi / 180)
                            camObjectAngleX = math.degrees(
                                math.atan((x - (ResizeWidth / 2)) / focalPixel))
                            camObjectAngleY = - math.degrees(math.atan((y - (
                                    ResizeHeight / 2)) / focalYpixel))

                        # On met toutes les valeurs récupérer dans chaque boucle dans un tableau de tableau. Permettant, par la suite, de les récupérer même en dehors
                        posPerson = [i, x, y, 0, camObjectAngleX, camObjectAngleY, 0]
                        allCamPosPerson.append(
                            posPerson)  # On fait un tableau contenant tous les tableaux réalisé

                    else:
                        posPerson = [i, 0, 0, 0, 0, 0, 0]  # Si on ne detecte personne, on met toutes les valeurs à 0
                        allCamPosPerson.append(posPerson)

            # RÃ©organisation des valeurs pour l'identification
            IdCam1P1 = 0
            IdCam2P1 = 0
            RecoverX = 0

            xSaveCam1 = []
            xSaveCam2 = []

            for k in range(len(allCamPosPerson)):
                if allCamPosPerson[k][0] == 0:
                    xSaveCam1.append(allCamPosPerson[k][1])
                if allCamPosPerson[k][0] == 1:
                    xSaveCam2.append(allCamPosPerson[k][1])

            xSaveCam1.sort()
            xSaveCam2.sort()

            # Attribution des IDs
            for k in range(len(allCamPosPerson)):
                if allCamPosPerson[k][0] == 0:
                    for l in range(len(xSaveCam1)):
                        if allCamPosPerson[k][1] == xSaveCam1[l]:
                            allCamPosPerson[k][6] = l
                if allCamPosPerson[k][0] == 1:
                    for l in range(len(xSaveCam2)):
                        if allCamPosPerson[k][1] == xSaveCam2[l]:
                            allCamPosPerson[k][6] = l

            # RÃ©initialiser les variables de tracking
            CenterCam1P1 = None
            CenterCam2P1 = None

            for k in range(len(allCamPosPerson)):
                if allCamPosPerson[k][6] == 0:
                    cv2.circle([frame1, frame2][allCamPosPerson[k][0]],
                               (allCamPosPerson[k][1], allCamPosPerson[k][2]),
                               radius=10, color=(255, 0, 0), thickness=-1)

                    if allCamPosPerson[k][0] == 0:
                        CenterCam1P1 = [allCamPosPerson[k][1], allCamPosPerson[k][2]]
                        angleXcam1P1 = allCamPosPerson[k][4]
                        angleYcam1P1 = allCamPosPerson[k][5]
                    if allCamPosPerson[k][0] == 1:
                        CenterCam2P1 = [allCamPosPerson[k][1], allCamPosPerson[k][2]]
                        angleXcam2P1 = allCamPosPerson[k][4]
                        angleYcam2P1 = allCamPosPerson[k][5]

            # Calcul des coordonnÃ©es 3D seulement si les deux points sont dÃ©tectÃ©s
            if CenterCam1P1 is not None and CenterCam2P1 is not None:
                disp12, posX12, posY12, posZ12 = coordCalculator(
                    CenterCam1P1, CenterCam2P1, frame1, frame2,
                    angleXcam1P1, angleXcam2P1, angleYcam1P1, angleYcam2P1,
                    cam_distance, cam_fov_h, cam_fov_h
                )

                posXP1 = posX12
                posYP1 = posY12
                posZP1 = posZ12

                # Mise Ã  jour des paramÃ¨tres de zone avec les valeurs des sliders
                hauteurCam = hauteur_var.get()
                zoneXmin = -taille_zone_x_var.get() + (horizontal_move_var.get() - 5)
                zoneXmax = taille_zone_x_var.get() + (horizontal_move_var.get() - 5)
                zoneZmin = depth_move_var.get() - 5
                zoneZmax = taille_zone_z_var.get() + (depth_move_var.get() - 5)

                # Calcul des points de la zone
                zoneRecoverX1, zoneRecoverY1 = refind_2d_coord(zoneXmax, hauteurCam, zoneZmin, fx_pixel, fy_pixel,
                                                               ResizeWidth, ResizeHeight)
                zoneRecoverX2, zoneRecoverY2 = refind_2d_coord(zoneXmin, hauteurCam, zoneZmin, fx_pixel, fy_pixel,
                                                               ResizeWidth, ResizeHeight)
                zoneRecoverX3, zoneRecoverY3 = refind_2d_coord(zoneXmin, hauteurCam, zoneZmax, fx_pixel, fy_pixel,
                                                               ResizeWidth, ResizeHeight)
                zoneRecoverX4, zoneRecoverY4 = refind_2d_coord(zoneXmax, hauteurCam, zoneZmax, fx_pixel, fy_pixel,
                                                               ResizeWidth, ResizeHeight)

                # CrÃ©ation des points pour le polygone
                zoneFramePoints = np.array([
                    [int(zoneRecoverX1), int(zoneRecoverY1)],
                    [int(zoneRecoverX2), int(zoneRecoverY2)],
                    [int(zoneRecoverX3), int(zoneRecoverY3)],
                    [int(zoneRecoverX4), int(zoneRecoverY4)]
                ]).astype(np.int32)

                # Dessiner la zone sur frame2
                cv2.polylines(frame2, [zoneFramePoints], True, color=(255, 0, 0), thickness=2)

                # Dessiner les points de repÃ¨re
                for x, y in [(zoneRecoverX1, zoneRecoverY1), (zoneRecoverX2, zoneRecoverY2),
                             (zoneRecoverX3, zoneRecoverY3), (zoneRecoverX4, zoneRecoverY4)]:
                    cv2.circle(frame2, (int(x), int(y)), radius=5, color=(255, 0, 0), thickness=-1)

                # VÃ©rification de la zone dangereuse
                colorbackground = (0, 0, 0)
                if zoneXmin <= posXP1 <= zoneXmax and zoneZmin <= posZP1 <= zoneZmax:
                    colorbackground = (0, 0, 255)
                    if not state["danger_sent"]:
                        send_telegram_alert(
                            f"âš ï¸ Intrusion dans la zone dangereuse !\nX={posXP1:.2f}, Y={posYP1:.2f}, Z={posZP1:.2f}")
                        state["danger_sent"] = True
                else:
                    state["danger_sent"] = False

                # Affichage des coordonnÃ©es
                cv2.rectangle(frame2, (30, 20), (500, 150), colorbackground, -1)
                cv2.putText(frame2, f"X P1 : {round(posXP1, 3)}", (100, 50),
                            cv2.FONT_HERSHEY_SIMPLEX, 1, (255, 255, 255), 2)
                cv2.putText(frame2, f"Y P1 : {round(posYP1, 3)}", (100, 80),
                            cv2.FONT_HERSHEY_SIMPLEX, 1, (255, 255, 255), 2)
                cv2.putText(frame2, f"Z P1 : {round(posZP1, 3)}", (100, 110),
                            cv2.FONT_HERSHEY_SIMPLEX, 1, (255, 255, 255), 2)

                zoneInterfacePoints = np.array([[int(zoneXmax * InterfaceCoordFactor + interface_width / 2),
                                                 int(zoneZmin * InterfaceCoordFactor + interface_height / 4)],
                                                [int(zoneXmin * InterfaceCoordFactor + interface_width / 2),
                                                 int(zoneZmin * InterfaceCoordFactor + interface_height / 4)],
                                                [int(zoneXmin * InterfaceCoordFactor + interface_width / 2),
                                                 int(zoneZmax * InterfaceCoordFactor + interface_height / 4)],
                                                [int(zoneXmax * InterfaceCoordFactor + interface_width / 2),
                                                 int(zoneZmax * InterfaceCoordFactor + interface_height / 4)]]).astype(
                    np.int32)

                zoneFramePoints = np.array(
                    [[int(zoneRecoverX1), int(zoneRecoverY1)], [int(zoneRecoverX2), int(zoneRecoverY2)],
                     [int(zoneRecoverX3), int(zoneRecoverY3)],
                     [int(zoneRecoverX4), int(zoneRecoverY4)]]).astype(np.int32)

                colorbackground = (255, 0, 0)
                if posXP1 < zoneXmax and posXP1 > zoneXmin:  # Detection de zone (Facultatif)
                    if posZP1 < zoneZmax and posZP1 > zoneZmin:
                        colorbackground = (0, 0, 255)

                radiusPolygonPointMin = int(10 - zoneZmin * 2)
                radiusPolygonPointMax = int(10 - zoneZmax * 2)

                if (radiusPolygonPointMin < 0):
                    radiusPolygonPointMin = 0
                if (radiusPolygonPointMax < 0):
                    radiusPolygonPointMax = 0

                # Affichage zone sur la frame de la caméra
                cv2.polylines(frame2, [zoneFramePoints], True, colorbackground, thickness=int(radiusPolygonPointMin))

                cv2.circle(frame2, (int(zoneRecoverX1), int(zoneRecoverY1)), radius=radiusPolygonPointMin,
                           color=(0, 255, 0), thickness=-1)

                cv2.circle(frame2, (int(zoneRecoverX2), int(zoneRecoverY2)), radius=radiusPolygonPointMin,
                           color=(0, 255, 0), thickness=-1)

                cv2.circle(frame2, (int(zoneRecoverX3), int(zoneRecoverY3)), radius=radiusPolygonPointMax,
                           color=(0, 255, 0), thickness=-1)

                cv2.circle(frame2, (int(zoneRecoverX4), int(zoneRecoverY4)), radius=radiusPolygonPointMax,
                           color=(0, 255, 0), thickness=-1)

                interface = vueDuDessus(zoneInterfacePoints, posXP1, posZP1, fx_pixel, interface_width,
                                        interface_height, interface_coord_factor, zoneXmin, zoneXmax, zoneZmin,
                                        zoneZmax, hauteurCam)

                # Convertir l'interface pour Tkinter
                interface_rgb = cv2.cvtColor(interface, cv2.COLOR_BGR2RGB)
                interface_img = Image.fromarray(interface_rgb)
                interface_tk = ImageTk.PhotoImage(interface_img)
                interface_label.imgtk = interface_tk
                interface_label.configure(image=interface_tk)

        # Redimensionner les frames pour l'affichage
        for i, frame in enumerate([frame1, frame2]):


            # Redimensionner
            frame = cv2.resize(frame, (int((screen_height/2) *1.77), int(screen_height/2)),interpolation=cv2.INTER_AREA)

            # Convertir et afficher
            frame_rgb = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
            frame_img = Image.fromarray(frame_rgb)
            frame_tk = ImageTk.PhotoImage(frame_img)
            video_labels[i][0].imgtk = frame_tk
            video_labels[i][0].configure(image=frame_tk)

        # Mettre Ã  jour la vue du dessus
        if state["tracking"] and CenterCam1P1 is not None and CenterCam2P1 is not None:
   

            # Redimensionner l'interface pour l'affichage
            interface = cv2.resize(interface, (int(screen_height/2), int(screen_height/2)),
                                   interpolation=cv2.INTER_AREA)

            # Convertir l'interface pour Tkinter
            interface_rgb = cv2.cvtColor(interface, cv2.COLOR_BGR2RGB)
            interface_img = Image.fromarray(interface_rgb)
            interface_tk = ImageTk.PhotoImage(interface_img)
            interface_label.imgtk = interface_tk
            interface_label.configure(image=interface_tk)

        # Planifier la prochaine mise Ã  jour
        video_labels[0][0].after(30, update_frame)

    def toggle_tracking():
        state["tracking"] = not state["tracking"]

    def cleanup():
        state["video_running"] = False
        state["tracking"] = False

    # DÃ©marrer la mise Ã  jour
    update_frame()

    # Interface de contrôle
    control_frame = ttk.Frame(frame)
    control_frame.pack(pady=10, fill="x")

    ttk.Button(control_frame, text="Démarrer / Arrêter le tracking", command=toggle_tracking).pack(side=tk.LEFT, padx=5)
    ttk.Button(control_frame, text="Arrêter et nettoyer", command=cleanup).pack(side=tk.LEFT, padx=5)


if __name__ == "__main__":
    danger_zone_show()