import torch
import os
import cv2
from PIL import Image, ImageTk
from ultralytics import YOLO

import tkinter as tk
from tkinter import ttk, filedialog, messagebox


def clear_frame(frame):
    for widget in frame.winfo_children():
        widget.destroy()

# === Détection de chutes ===
def fall_detection_show(frame, app_state):
    clear_frame(frame)
    model = #############@
    if torch.cuda.is_available():
        model.to("cuda")

    mode_var = tk.StringVar(value="camera")
    confidence_var = tk.DoubleVar(value=0.5)
    video_path_var = tk.StringVar()
    alert_sent = False

    def select_file():
        file_path = filedialog.askopenfilename(filetypes=[("Video files", "*.mp4 *.avi *.mov *.mkv")])
        video_path_var.set(file_path)

    def process_frame(frame):
        nonlocal alert_sent
        if mode_var.get() == "camera":
            ########
        else :
            ##############
        results = ##############
        for result in results:
            for box in result.boxes:
                x1, y1, x2, y2 = map(int, box.xyxy[0])
                conf = float(box.conf[0])
                cls = int(box.cls[0])
                label = f"{'No Fall' if cls == 1 else 'Fall'} {conf:.2f}"
                color = (0, 255, 0) if cls == 1 else (0, 0, 255)
                cv2.rectangle(frame, (x1, y1), (x2, y2), color, 2)
                cv2.putText(frame, label, (x1, y1 - 10), cv2.FONT_HERSHEY_SIMPLEX, 0.5, color, 2)
                ##### TO DO #######
                #####DETECTION -> ALERTE #######

        return frame

    # def process_frame(frame, model):
    # # Redimensionner l'image pour de meilleures performances

    # results = model.predict(source=frame, conf=0.5)

    # # Dessiner les boîtes de détection sur l'image
    # for result in results:
    #     boxes = result.boxes
    #     for box in boxes:
    #         x1, y1, x2, y2 = box.xyxy[0]
    #         conf = box.conf[0]
    #         cls = int(box.cls[0])

    #         # Convertir les coordonnées en entiers
    #         x1, y1, x2, y2 = map(int, [x1, y1, x2, y2])

    #         # Dessiner la boîte
    #         color = (0, 255, 0) if cls == 1 else (0, 0, 255)  # Vert pour "nofall", Rouge pour "fall"
    #         cv2.rectangle(frame, (x1, y1), (x2, y2), color, 2)

    #         # Ajouter le label et la confiance
    #         label = f"{'No Fall' if cls == 1 else 'Fall'} {conf:.2f}"
    #         cv2.putText(frame, label, (x1, y1-10), cv2.FONT_HERSHEY_SIMPLEX, 0.5, color, 2)

    # return frame, results


    def start_detection():
        print("Démarrage de la détection...")
        nonlocal alert_sent
        alert_sent = False

        # Créer un frame pour la vidéo
        video_frame = ttk.Frame(frame)
        video_frame.pack(pady=10, fill="both", expand=True)
        print("Frame vidéo créé")
        
        # Créer un label pour afficher la vidéo
        video_label = ttk.Label(video_frame)
        video_label.pack(fill="both", expand=True)
        print("Label vidéo créé")

        cap = None
        if mode_var.get() == "camera":
            # Utiliser la caméra servo si disponible
            if app_state["servo_camera"] and app_state["servo_camera"][1].isOpened():
                ############
                ####TO COMPLETE
            # Sinon utiliser une caméra fixe
            elif app_state["fix_cameras"]:
                ############
                ####TO COMPLETE
            else:
                messagebox.showerror("Erreur", "Aucune caméra disponible")
                return
        else:
            video_path = video_path_var.get()
            if not video_path or not os.path.exists(video_path):
                print("Erreur: Fichier vidéo invalide")
                messagebox.showerror("Erreur", "Fichier vidéo invalide")
                return
            ############
            ####TO COMPLETE

        if not cap or not cap.isOpened():
            print("Erreur: Impossible d'ouvrir la source vidéo")
            messagebox.showerror("Erreur", "Impossible d'ouvrir la source vidéo")
            return

        #window = tk.Toplevel(frame)
        #window.title("Détection de Chutes - Lecture")
        #lbl = ttk.Label(window)
        #lbl.pack()
        if video_path is not None:
            type = "video"
        else:
            type = "camera"

        print(f"type: {type}")

        def update(type):
            if cap and cap.isOpened():
                ret, frame = cap.read()
                if type == "video":
                    print("rotation")
                    frame = cv2.rotate(frame, cv2.ROTATE_90_CLOCKWISE)

                if ret:
                    # Convertir en RGB pour l'affichage
                    frame = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
                    frame = process_frame(frame)
                    
                    # Vérifier si la fenêtre a des dimensions valides
                    try:
                        # Obtenir les dimensions du frame
                        frame_width = video_frame.winfo_width()
                        frame_height = video_frame.winfo_height()
                        
                        if frame_width > 1 and frame_height > 1:
                            # Calculer le ratio pour maintenir les proportions
                            h, w = frame.shape[:2]
                            ratio = min(frame_width/w, frame_height/h)
                            new_size = (int(w*ratio), int(h*ratio))
                            frame = cv2.resize(frame, new_size)
                        else:
                            # Taille par défaut si les dimensions ne sont pas encore disponibles
                            frame = cv2.resize(frame, (640, 480))

                            
                        # Convertir en PhotoImage pour Tkinter
                        img = Image.fromarray(frame)
                        imgtk = ImageTk.PhotoImage(image=img)
                        
                        # Mettre à jour le label
                        video_label.imgtk = imgtk
                        video_label.configure(image=imgtk)
                        
                        # Planifier la prochaine mise à jour
                        video_label.after(30, update, type)
                    except Exception as e:
                        print(f"Erreur lors du redimensionnement: {str(e)}")
                        video_label.after(30, update, type)
                else:
                    print("Fin de la lecture vidéo")
                    cap.release()
                    video_label.destroy()
            else:
                print("Erreur: La capture vidéo n'est plus disponible")
                video_label.destroy()

        print("Démarrage de la mise à jour de la vidéo")
        update(type)

    # Interface utilisateur
    control_frame = ttk.Frame(frame)
    control_frame.pack(pady=10)
    
    ttk.Label(control_frame, text="Détection de Chutes", font=("Helvetica", 16)).pack(pady=10)
    
    options_frame = ttk.Frame(control_frame)
    options_frame.pack(pady=10)
    ttk.Radiobutton(options_frame, text="Caméra", variable=mode_var, value="camera").grid(row=0, column=0, padx=5)
    ttk.Radiobutton(options_frame, text="Fichier Vidéo", variable=mode_var, value="video").grid(row=0, column=1, padx=5)
    
    file_frame = ttk.Frame(control_frame)
    file_frame.pack(pady=5)
    ttk.Entry(file_frame, textvariable=video_path_var, width=40).grid(row=0, column=0, padx=5)
    ttk.Button(file_frame, text="Choisir un fichier", command=select_file).grid(row=0, column=1)
    
    ttk.Label(control_frame, text="Seuil de Confiance").pack()
    ttk.Scale(control_frame, from_=0.0, to=1.0, variable=confidence_var, orient=tk.HORIZONTAL, length=300).pack()
    
    def on_start_click():
        print("Bouton cliqué!")
        start_detection()
        
    def stop_detection():

        state["tracking"] = False
        state["video_running"] = False

    ttk.Button(control_frame, text="Arrêter", command=stop_detection).pack(pady=10)


    start_button = ttk.Button(control_frame, text="Démarrer la Détection", command=on_start_click)
    start_button.pack(pady=10)
    print("Bouton de démarrage créé")
    
    #ttk.Button(control_frame, text="← Retour au menu", command=lambda: show_main_menu(frame)).pack(pady=10)

if __name__ == "__main__":
    show() 