import cv2
import numpy as np
from ultralytics import YOLO
import time
from datetime import datetime, timedelta
import pages.ServoKitCalib as ServoKitCalib
import subprocess
from pages.ServoKitCalib import ServoKit
from PIL import Image, ImageTk
import tkinter as tk
from tkinter import ttk, filedialog, messagebox
import os


def forgotten_objects_show(frame, app_state, root):
    # Variables d'état
    state = {
        "mode": tk.StringVar(value="camera"),
        "model": None,
        "tracking": False,
        "video_running": True,
        "image_path": tk.StringVar()
    }

    # Créer un conteneur pour les flux vidéo
    video_container = ttk.Frame(frame)
    video_container.pack(pady=10, fill="both", expand=True)
    video_labels = []

    # Frame pour les caméras fixes
    fix_cameras_frame = ttk.Frame(video_container)
    fix_cameras_frame.pack(fill="x", expand=True, pady=5)
    
    # Afficher les caméras fixes
    for path, (camera_path, cap) in app_state["fix_cameras"].items():
        fix_frame = ttk.Frame(fix_cameras_frame)
        fix_frame.pack(side=tk.LEFT, padx=5, fill="both", expand=True)
        fix_label = ttk.Label(fix_frame)
        fix_label.pack(fill="both", expand=True)
        video_labels.append((fix_label, f"Camera fixe: {camera_path[0]}"))

    # Frame pour la caméra sur servomoteur
    servo_frame = ttk.Frame(video_container)
    servo_frame.pack(fill="x", expand=True, pady=5)
    
    # Afficher la caméra sur le servomoteur
    if app_state["servo_camera"]:
        
        servo_path = app_state["servo_camera"][0]
        servo_label = ttk.Label(servo_frame)
        servo_label.pack(fill="both", expand=True)
        video_labels.append((servo_label, "Camera sur servomoteur"))

    def init_model():
        if state["model"] is None:
            #### TO COMPLETE ########

    def select_image():
        file_path = filedialog.askopenfilename(
            filetypes=[("Image files", "*.jpg *.jpeg *.png *.bmp *.gif")]
        )
        if file_path:
            state["image_path"].set(file_path)

    def start_camera_mode():
        init_model()
        
        # Vérifier que les caméras sont initialisées
        if not app_state["servo_camera"] and not app_state["fix_cameras"]:
            messagebox.showerror("Erreur", "Aucune caméra n'est initialisée")
            return

        state["tracking"] = True
        update_camera_frames()

    def start_image_mode():
        init_model()
        
        image_path = state["image_path"].get()
        if not image_path or not os.path.exists(image_path):
            messagebox.showerror("Erreur", "Veuillez sélectionner une image valide")
            return

        # Lire l'image
        frame = cv2.imread(image_path)
        if frame is None:
            messagebox.showerror("Erreur", "Impossible de lire l'image")
            return

        # Détection des objets
        results = state["model"](frame)
        
        # Traitement des résultats
        #### TO COMPLETE #### 

        # Redimensionner et afficher
        frame = cv2.resize(frame, (640, 480))
        frame = cv2.flip(frame, 0)  # Retourner l'image verticalement
        img_rgb = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
        imgtk = ImageTk.PhotoImage(Image.fromarray(img_rgb))
        video_labels[0][0].imgtk = imgtk
        video_labels[0][0].config(image=imgtk)

    def update_camera_frames():
        if not state["tracking"]:
            return

        # Traiter les caméras fixes
        for i, (path, (camera_path, cap)) in enumerate(app_state["fix_cameras"].items()):
            ret, frame = cap.read()
            if ret:
                # Détection des objets
               ####### TO COMPLETE  ###### 
                
                # Traitement des résultats
                ##### TO COMPLETE #########

                # Redimensionner et afficher
                frame = cv2.resize(frame, (640, 480))  # Taille plus grande pour les caméras fixes
                frame = cv2.flip(frame, 0)  # Retourner l'image verticalement
                cv2.putText(frame, video_labels[i][1], (10, 30), cv2.FONT_HERSHEY_SIMPLEX, 0.7, (255, 255, 255), 2)
                img_rgb = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
                imgtk = ImageTk.PhotoImage(Image.fromarray(img_rgb))
                video_labels[i][0].imgtk = imgtk
                video_labels[i][0].config(image=imgtk)

        # Traiter la caméra sur le servomoteur
        if app_state["servo_camera"]:
            cap = app_state["servo_camera"][1]
            ret, frame = cap.read()
            if ret:
                # Détection des objets
                results = state["model"](frame)
                
                # Traitement des résultats
                for r in results:
                    for box in r.boxes:
                        class_id = int(box.cls.item())
                        class_name = state["model"].names[class_id]
                        conf = box.conf.item()
                        
                        if conf > 0.5:  # Seuil de confiance
                            x1, y1, x2, y2 = map(int, box.xyxy[0].tolist())
                            
                            # Définir la couleur selon la classe
                            color = (0, 255, 0)  # Vert par défaut
                            if class_name in ["key", "keys"]:
                                color = (0, 0, 255)  # Rouge pour les clés
                                send_telegram_alert(f"Clés détectées sur la caméra principale")
                            elif class_name in ["phone", "cell phone"]:
                                color = (255, 0, 0)  # Bleu pour les téléphones
                            
                            # Dessiner la boîte et le texte
                            cv2.rectangle(frame, (x1, y1), (x2, y2), color, 2)
                            cv2.putText(frame, f"{class_name} {conf:.2f}", (x1, y1 - 10),
                                      cv2.FONT_HERSHEY_SIMPLEX, 0.7, color, 2)

                # Redimensionner et afficher
                frame = cv2.resize(frame, (1280, 720))  # Taille encore plus grande pour la caméra mobile
                frame = cv2.flip(frame, 0)  # Retourner l'image verticalement
                cv2.putText(frame, video_labels[-1][1], (10, 30), cv2.FONT_HERSHEY_SIMPLEX, 0.7, (255, 255, 255), 2)
                img_rgb = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
                imgtk = ImageTk.PhotoImage(Image.fromarray(img_rgb))
                video_labels[-1][0].imgtk = imgtk
                video_labels[-1][0].config(image=imgtk)

        if state["tracking"]:
            video_labels[0][0].after(30, update_camera_frames)

    def stop_camera_mode():
        state["tracking"] = False
        state["video_running"] = False

    # Interface de contrôle
    control_frame = ttk.Frame(frame)
    control_frame.pack(pady=10)

    # Mode de détection
    mode_frame = ttk.Frame(frame)
    mode_frame.pack(pady=5)
    ttk.Radiobutton(mode_frame, text="Caméras", variable=state["mode"], value="camera").pack(side=tk.LEFT, padx=5)
    ttk.Radiobutton(mode_frame, text="Image", variable=state["mode"], value="image").pack(side=tk.LEFT, padx=5)

    # Sélection d'image
    image_frame = ttk.Frame(frame)
    image_frame.pack(pady=5)
    ttk.Entry(image_frame, textvariable=state["image_path"], width=40).pack(side=tk.LEFT, padx=5)
    ttk.Button(image_frame, text="Choisir une image", command=select_image).pack(side=tk.LEFT, padx=5)

    # Boutons de contrôle
    ttk.Button(control_frame, text="Démarrer", 
               command=lambda: start_image_mode() if state["mode"].get() == "image" else start_camera_mode()
    ).pack(side=tk.LEFT, padx=5)
    ttk.Button(control_frame, text="Arrêter", command=stop_camera_mode).pack(side=tk.LEFT, padx=5)
    ttk.Button(control_frame, text="Retour", command=lambda: frame.destroy()).pack(side=tk.LEFT, padx=5)
    ttk.Button(control_frame, text="Quitter", command=lambda: root.destroy()).pack(side=tk.RIGHT, padx=5)

if __name__ == "__main__":
    show() 