#import streamlit as st
import cv2
import numpy as np
from ultralytics import YOLO
import time
import pages.ServoKitCalib as ServoKitCalib
import subprocess
import tkinter as tk
from tkinter import ttk, filedialog, messagebox
from PIL import Image, ImageTk

from ultralytics import YOLO
import cv2
import time
from PIL import Image, ImageTk
import pages.ServoKitCalib as ServoKitCalib



def PTZTracking(anglePan, angleTilt, x, y, width, height):
    fps = 30
    frameRate = 1/fps
    vMaxPan = 1000
    vMaxTilt = 1000
    deadZoneX = 0.1
    deadZoneY = 0.1
    speedFactor = 0.3

    centreX = width / 2
    centreY = height / 2

    decalageX = -(x - centreX) / (centreX / 1)
    decalageY = -(y - centreY) / (centreY / 1)

    speedPan = 0
    speedTilt = 0
    if(decalageX > deadZoneX or decalageX < -deadZoneX):
        speedPan = vMaxPan * decalageX * frameRate * speedFactor

    if (decalageY > deadZoneY or decalageY < -deadZoneY):
        speedTilt = vMaxTilt * decalageY * frameRate * speedFactor

    anglePan += speedPan
    angleTilt += speedTilt

    return anglePan, angleTilt


def person_tracking_show(frame, app_state):
    ttk.Label(frame, text="Tracking de Personnes", font=("Helvetica", 16)).pack(pady=10)

    # Frame pour la vidéo
    video_frame = ttk.Frame(frame)
    video_frame.pack(pady=10, fill="both", expand=True)

    # Afficher le nom de la caméra active
    if app_state["servo_camera"]:
        cam = app_state["servo_camera"][0]
        servo_name = cam[1].split('video')[1]
        ttk.Label(frame, text=f"Caméra active: {servo_name}", font=("Helvetica", 10)).pack(pady=5)

    # Centrer la vidéo
    video_label = ttk.Label(video_frame)
    video_label.pack(pady=10, anchor="center", expand=True)

    state = {
        "model": None,
        "tracking": False,
        "angle_pan": 0,
        "angle_tilt": 0,
        "video_running": False,
        "frame_count": 0  # Compteur de frames
    }

    def init_model():
        if state["model"] is None:
            state["model"] = YOLO("pages/model/yolo11s-pose.pt")

    def toggle_tracking():
        if not app_state["servo_camera"] or not app_state["servo_kit"]:
            messagebox.showwarning("Attention", "Caméra non initialisée")
            return
        state["tracking"] = not state["tracking"]
        if state["tracking"] and not state["video_running"]:
            state["frame_count"] = 0  # Réinitialiser le compteur
            update_video()

    def update_video():
        if not state["tracking"] or not app_state["servo_camera"]:
            return

        cap = app_state["servo_camera"][1]
        ret, frame = cap.read()
        if not ret:
            return

        frame = cv2.flip(frame, 0)
        
        # Redimensionner l'image pour l'affichage (taille réduite)
        display_width = 640  # Largeur réduite
        display_height = 480  # Hauteur réduite
        frame = cv2.resize(frame, (display_width, display_height))
        
        # Incrémenter le compteur de frames
        state["frame_count"] += 1
        
        # Ne traiter qu'une frame sur 2
        if state["frame_count"] % 2 == 0:
            height, width = frame.shape[:2]

            # Détection et tracking
            results = state["model"](frame, stream=True, batch=1, verbose=False)
            
            for r in results:
                keypoints = r.keypoints.xy
                for j in range(len(keypoints)):
                    if len(keypoints[0]) > 0:

                        x, y = int(keypoints[j][0][0]), int(keypoints[j][0][1])
                        if x == 0 and y == 0:
                            continue
                        cv2.circle(frame, (x, y), radius=5, color=(255, 255, 0), thickness=-1)
                        
                        # Mise à jour des angles
                        state["angle_pan"], state["angle_tilt"] = PTZTracking(
                            state["angle_pan"],
                            state["angle_tilt"],
                            x, y,
                            width, height
                        )
                        
                        # Limitation des angles
                        if state["angle_pan"] > app_state["servo_kit"].getMaxRotation():
                            state["angle_pan"] = app_state["servo_kit"].getMaxRotation()

                        if state["angle_pan"] < -app_state["servo_kit"].getMaxRotation():
                            state["angle_pan"] = -app_state["servo_kit"].getMaxRotation()

                        if state["angle_tilt"] > app_state["servo_kit"].getMaxRotation():
                            state["angle_tilt"] = app_state["servo_kit"].getMaxRotation()

                        if state["angle_tilt"] < -app_state["servo_kit"].getMaxRotation():
                            state["angle_tilt"] = -app_state["servo_kit"].getMaxRotation()
                        
                        # Mise à jour des servomoteurs
                        app_state["servo_kit"].setAngleDeg(0, state["angle_pan"])
                        app_state["servo_kit"].setAngleDeg(1, state["angle_tilt"])

        # Affichage de la frame
        img_rgb = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
        imgtk = ImageTk.PhotoImage(Image.fromarray(img_rgb))
        video_label.imgtk = imgtk
        video_label.config(image=imgtk)

        if state["tracking"]:
            video_label.after(30, update_video)

    def cleanup():
        state["tracking"] = False
        state["video_running"] = False
        state["frame_count"] = 0  # Réinitialiser le compteur

    init_model()

    # Frame pour les contrôles
    control_frame = ttk.Frame(frame)
    control_frame.pack(pady=10, fill="x")

    # Boutons de contrôle
    ttk.Button(control_frame, text="Démarrer / Arrêter le tracking", command=toggle_tracking).pack(side="left", padx=5)
    ttk.Button(control_frame, text="Arrêter et nettoyer", command=cleanup).pack(side="left", padx=5)
   
    
if __name__ == "__main__":
    show() 